﻿var strataWizard = {
    context: $(".v-strataDefinitionWizard"),
    backButton: $("#backButton", this.context),
    nextButton: $("#nextButton", this.context),
    saveButton: $("#saveButton", this.context),
    navigationButtons: $(".breadcrumb li", this.context),
    strataGenerationLimit: 0,

    pages: [],
    currentPageIndex: -1,

    initialize: function () {
        this.pages = $(".page", this.context);
        this.strataGenerationLimit = Math.min($("#StrataGenerationLimit").val(), 100000);
        this.bindEvents();
        this.navigateToPage(0);
    },

    bindEvents: function () {
        this.backButton.on("click", function () {
            strataWizard.navigateToPage(strataWizard.currentPageIndex - 1);
        });

        this.nextButton.on("click", function () {
            strataWizard.navigateToPage(strataWizard.currentPageIndex + 1);
        });

        this.saveButton.on("click", function () {
            var nbRecords = pageSummary.stratasDataTable.a4datatable("getTotalRecords");

            if (nbRecords <= 0) {
                a4.showErrorMessage(a4.top().resources.StrataRequired);
            }
            else {
                a4.callServerMethod(a4.getProjectAction("InsertMultipleStrataFromWizard", "Quotas"), { serializedStrata: JSON.stringify(pageSummary.stratasDataTable.a4datatable("getRowsData")) }, function (result) {
                    a4.parent().quotas.refreshContent(true);
                    return modalDialog.close();
                });
                modalDialog.close();
            }
        });
    },

    navigateToPage: function (index) {
        if (this.currentPageIndex !== index) {
            // Show current page
            $(this.pages).hide();
            $(this.pages[index]).show();

            // Set current page index
            this.currentPageIndex = index;

            // Set navignation buttons status
            this.navigationButtons.removeClass("current");
            $(this.navigationButtons[this.currentPageIndex]).addClass("current");

            this.backButton.toggle(this.currentPageIndex > 0);
            this.nextButton.toggle(this.currentPageIndex < this.pages.length - 1);
            this.saveButton.toggle(this.currentPageIndex == this.pages.length - 1);

            // Initialize current page
            switch (this.currentPageIndex) {
                case 0: pageQuestions.onShowPage(); break;
                case 1: pageSelection.onShowPage(); break;
                case 2: pageSummary.onShowPage(); break;
                default: break;
            }
        }
    },

    setNavigantionButtonState: function (index, enabled) {
        if (enabled) {
            $(this.navigationButtons[index]).removeClass("non-clickable");
            $(this.navigationButtons[index]).on("click", function () {
                strataWizard.navigateToPage($(this).index());
            });
        }
        else {
            $(this.navigationButtons[index]).addClass("non-clickable");
            $(this.navigationButtons[index]).prop("onclick", null).off("click");
        }
    },
}

var pageQuestions = {
    context: $(".v-strataDefinitionWizard"),

    questionsDataTable: null,
    selectedQuestions: [],

    onShowPage: function () {
        if (this.questionsDataTable == null)
            this.initializeQuestionsDataTable();
        else
            this.questionsDataTable.a4datatable("refresh");

        this.setNavigantionButtonsState();
    },

    initializeQuestionsDataTable: function () {
        this.questionsDataTable = $(".h-questions", this.context).a4datatable({
            ajaxAction: a4.getProjectAction("GetQuestionnaireQuestions", "Shared"),
            displayColumnSelector: false,
            rememberRowSelection: true,
            allowRowSelection: function (row) {
                return pageSelection.selectedQuestions.indexOf(row.Name) == -1;
            },
            height: "full",
            columns: [
                { "Data": "Id", "Visible": false, "Key": true },
                { "Data": "Name", "Title": resources.Questions }
            ],
            selectRow: function (event, data) {
                pageQuestions.selectedQuestions = data.selectedRows.map(function (x) { return x.Name });
                pageQuestions.setNavigantionButtonsState();
            }
        });
    },

    setNavigantionButtonsState: function () {
        strataWizard.nextButton.prop('disabled', this.selectedQuestions.length == 0);
        strataWizard.setNavigantionButtonState(1, this.selectedQuestions.length > 0);
        strataWizard.setNavigantionButtonState(2, this.selectedQuestions.length > 0 && pageSelection.expressions.length > 0);
    }
}

var pageSelection = {
    context: $(".v-strataDefinitionWizard"),
    groupButton: $("#groupButton", this.context),
    crossButton: $("#crossButton", this.context),
    addButton: $("#addButton", this.context),

    createdGroups: [],
    selectedQuestions: [],
    choicesListView: null,
    selectedChoices: [],
    expressions: [],
    expressionsDataTable: null,

    onShowPage: function () {
        this.selectedChoices = [];
        this.selectedQuestions = pageQuestions.selectedQuestions.map(function (x) { return x });
        this.initializeQuestionsList();
        this.setNavigantionButtonsState();
        this.setLeftPanButtonsState();
        this.bindEvents();
    },

    initializeQuestionsList: function () {
        if (pageQuestions.selectedQuestions.length > 0) {
            var questionsName = pageQuestions.selectedQuestions.join(",");

            if (this.choicesListView != null) {
                this.choicesListView.a4listview("setAjaxParams", { questionsName: questionsName });
                this.choicesListView.a4listview("refresh");
                return;
            }
            this.choicesListView = $(".h-choices", this.context).a4listview({
                ajaxAction: a4.getProjectAction("GetQuestionsChoices", "Quotas"),
                ajaxParams: { questionsName: questionsName },
                displayActionButtonsOnLeft: true,
                displayActionButtonsOnHover: false,
                allowNodeHighlight: false,
                displaySearchBox: false,
                properties: {                    
                    Children: "Choices"
                },
                icons: null,
                actionButtons: [
                    { Action: "select", Label: resources.Select, Icon: "checkbox-unchecked", DisplayCondition: function (data) { return pageSelection.evaluateListActionButtons(data, "unchecked"); } },
                    { Action: "select", Label: resources.Select, Icon: "checkbox-partial", DisplayCondition: function (data) { return pageSelection.evaluateListActionButtons(data, "partial"); } },
                    { Action: "unselect", Label: resources.Unselect, Icon: "checkbox-checked", DisplayCondition: function (data) { return pageSelection.evaluateListActionButtons(data, "checked"); } },
                ],
                actionButtonClick: function (event, data) {
                    pageSelection.onSelectOption(data.node, data.action == "select");
                },
                localizableTexts: { "Search": resources.SearchQuestions }
            });
        }
    },

    initializeExpressionsList: function () {
        this.expressionsDataTable = $(".h-definitions", this.context).a4datatable({
            serverSide: false,
            displaySearchBox: false,
            displayColumnSelector: false,
            rememberRowSelection: true,
            allowRowSelection: true,
            lengthMenu: [
                [10, 20, 50, 100, 500, 1000],
                ['10', '20', '50', '100', '500', '1000']
            ],
            height: "full",
            columns: [
                { "Data": "Id", "Visible": false, "Key": true },
                { "Data": "Name", "Title": resources.Expressions }
            ],
            data: pageSelection.expressions,
            selectRow: function (event, data) {
                pageSelection.onSelectExpression(data.data[0].Id, data.isChecked);
            },
            toolBarItems: [{ "Action": "remove", "Label": resources.Remove }],
            toolBarClick: function (event, data) {
                switch (data.action) {
                    case "remove":
                        pageSelection.remove(data.rows);
                        break;
                };
            },
        });

        this.setNavigantionButtonsState();
    },

    bindEvents: function () {
        this.groupButton.off('click').on("click", function () {
            pageSelection.group();
        });

        this.crossButton.off('click').on("click", function () {
            pageSelection.cross();
        });

        this.addButton.off('click').on("click", function () {
            pageSelection.add();
        });
    },

    evaluateListActionButtons: function (item, action) {
        var isVisible = false;

        if (item.IsQuestion) {
            var selectedChoices = _.filter(item.Choices, function (x) { return x.Selected === true; });

            isVisible = (action == "unchecked" && selectedChoices.length == 0) ||
                        (action == "partial" && selectedChoices.length > 0 && selectedChoices.length < item.Choices.length) ||
                        (action == "checked" && selectedChoices.length == item.Choices.length);
        }
        else {
            isVisible = (action != "partial") &&
                        (action == "unchecked" && item.Selected === false) || (action == "checked" && item.Selected === true);
        }

        return isVisible;
    },

    onSelectOption: function (item, selected) {
        // if choice checked
        if (selected) {
            if (item.IsQuestion) {
                item.Choices = _.map(item.Choices, function (choice) {
                    pageSelection.addSelectedChoice(choice);
                    choice.Selected = true;
                    return choice;
                });
            }
            else {
                this.addSelectedChoice(item);
                item.Selected = true;
            }
        }
            // if choice unchecked
        else {
            if (item.IsQuestion) {
                item.Choices = _.map(item.Choices, function (choice) {
                    choice.Selected = false;
                    pageSelection.deleteSelectedChoice(choice);
                    return choice;
                });
            }
            else {
                item.Selected = false;
                this.deleteSelectedChoice(item);
            }
        }

        this.choicesListView.a4listview("evaluateActionsConditions", item.ListView_Internal_Key);
        this.choicesListView.a4listview("evaluateActionsConditions", item.ListView_Internal_ParentKey);

        this.setLeftPanButtonsState();
    },

    onSelectExpression: function (id, isSelected) {
        for (var index in pageSelection.expressions) {
            if (pageSelection.expressions[index].Id == id) {
                pageSelection.expressions[index].isSelected = isSelected;
                this.setNavigantionButtonsState();
                return;
            }
        }
    },

    setNavigantionButtonsState: function () {
        strataWizard.nextButton.prop('disabled', this.expressions.length == 0);
        strataWizard.setNavigantionButtonState(0, true);
        strataWizard.setNavigantionButtonState(2, this.expressions.length > 0);
    },

    addSelectedChoice: function (choice) {
        newChoice = {
            Index: choice.Index,
            Id: choice.Id,
            Name: choice.Name,
            Code: choice.Code,
            Label: choice.Label,
            Expression: choice.Expression,
            Question: choice.Question,
            Type: choice.Type,
            Selected: choice.Selected
        }

        if (this.selectedChoices[choice.Question]) {
            if (this.indexOfSelectedChoice(newChoice) == -1) {
                var insertPosition = this.getSelectedChoiceInsertPosition(newChoice);
                this.selectedChoices[choice.Question].splice(insertPosition, 0, newChoice);
            }
        }
        else {
            this.selectedChoices[choice.Question] = [newChoice];
        }
    },

    deleteSelectedChoice: function (choice) {
        if (this.selectedChoices[choice.Question]) {
            var index = this.indexOfSelectedChoice(choice);
            this.selectedChoices[choice.Question].splice(index, 1);

            if (this.selectedChoices[choice.Question].length == 0)
                delete this.selectedChoices[choice.Question];
        }
    },

    indexOfSelectedChoice: function (choice) {
        for (var index in this.selectedChoices[choice.Question]) {
            if (this.selectedChoices[choice.Question][index].Id == choice.Id)
                return index;
        }
        return -1;
    },

    getSelectedChoiceInsertPosition: function (choice) {
        for (var index in this.selectedChoices[choice.Question]) {
            if (this.selectedChoices[choice.Question][index].Index > choice.Index)
                return this.indexOfSelectedChoice(this.selectedChoices[choice.Question][index]);
        }
        return this.selectedChoices[choice.Question].length;
    },

    getNextGroupIndex: function (question) {
        var nodes = this.choicesListView.a4listview('getNodes');
        var groups = nodes.filter(function (x) { return x.Question == question && x.Type == 'group' });
        return ++groups.length;
    },

    getNextCrossIndex: function () {
        var nodes = this.expressionsDataTable ? this.expressionsDataTable.a4datatable('getRowsData') : [];
        var crosses = nodes.filter(function (x) { return x.Type == 'cross' });
        var maxIndex = crosses.length > 0 ? _.max(crosses, function (c) { return c.Index; }).Index : 0;

        return ++maxIndex;
    },

    group: function () {
        for (var question in this.selectedChoices) {
            // filter choices only
            var choices = this.selectedChoices[question].filter(function (x) { return x.Type == 'choice' });

            var groupToAdd = question + "," + choices.map(function (elem) { return elem.Id; }).join(",");

            if (pageSelection.createdGroups.indexOf(groupToAdd) > -1) {
                this.clearChoices();
                return;
            }

            pageSelection.createdGroups.push(groupToAdd);

            if (choices.length > 1) {
                var index = this.getNextGroupIndex(question);
                var groupeName = resources.Group + '-' + index;
                var choicesConcat = this.getChoicesConcatForGroup(choices);

                newGroup = {
                    Id: question + '-' + groupeName,
                    Name: "<i class='fa fa-object-group'></i> <strong>" + groupeName + ' (' + choicesConcat.Code + ')</strong>',
                    Code: groupeName,
                    Expression: choicesConcat.Expression,
                    Label: groupeName,
                    Question: question,
                    Type: 'group',
                    Selected: false,
                    ListView_Internal_Key: question + '_' + question + '-' + groupeName,
                    ListView_Internal_ParentKey: question
                };

                this.choicesListView.a4listview('addNode', newGroup);
            }
        }

        this.clearChoices();
    },

    add: function () {
        var newStrataCount = _.flatten(_.values(this.selectedChoices)).length;

        if (newStrataCount + this.getGeneratedStrataCount() > strataWizard.strataGenerationLimit) {
            a4.showErrorMessage(resources.StrataGenerationLimitExceeded);
        }
        else {
            for (var question in this.selectedChoices) {
                for (var i in this.selectedChoices[question]) {
                    var choice = this.selectedChoices[question][i];
                    var expression = {
                        Id: choice.Id,
                        Name: choice.Question + ' ' + choice.Label,
                        Code: choice.Code,
                        Label: choice.Label,
                        Expression: choice.Expression,
                        Question: choice.Question,
                        Type: choice.Type,
                        isSelected: false
                    };

                    this.insertExpression(expression);
                }
            }

            this.initializeExpressionsList();
            this.clearChoices();
        }
    },

    remove: function (rows) {
        for (var i in rows) {
            for (var index in this.expressions) {
                if (this.expressions[index].Id == rows[i].Id) {
                    this.expressions.splice(index, 1);
                    break;
                }
            }
        }
        this.expressionsDataTable.a4datatable("refresh", true, true);
        this.initializeExpressionsList();
    },

    cross: function () {
        var index = this.getNextCrossIndex();
        var name = resources.Cross + ' ' + index + ' ';
        var choiceStack = [];

        var newStrataCount = _.reduce(_.values(this.selectedChoices), function (count, choices) { return count * choices.length; }, 1);

        if (newStrataCount + this.getGeneratedStrataCount() > strataWizard.strataGenerationLimit) {
            a4.showErrorMessage(resources.StrataGenerationLimitExceeded);
        }
        else {
            for (var question in this.selectedChoices) {
                choiceStack.push(this.selectedChoices[question]);
                name += question + '(' + this.selectedChoices[question].map(function (choice) { return choice.Code }).join(', ') + '), ';
            }

            name = name.substring(0, name.length - 2);

            var crosses = this.crossChoiceLists(choiceStack);

            var cross = {
                Id: 'cross' + index,
                Index: index,
                Name: name,
                Code: 'cross' + index,
                Label: 'cross' + index,
                Expressions: [],
                Type: 'cross',
                isSelected: false
            };

            for (var i in crosses) {
                cross.Expressions.push(crosses[i].Expression);
            }

            this.insertExpression(cross);

            this.initializeExpressionsList();
            this.clearChoices();
        }
    },
    crossChoiceLists: function (choiceLists) {
        return _.reduce(choiceLists, function (a, b) {
            return _.flatten(_.map(a, function (x) {
                return _.map(b, function (y) {
                    var cross = {};

                    if (x && y) {
                        cross = {
                            Code: x.Code + '-' + y.Code,
                            Name: x.Name + ' X ' + y.Name,
                            Expression: x.Expression + ' X ' + y.Expression
                        };
                    }

                    return cross;
                });
            }), true);
        });
    },
    getChoiceExpression: function (choice) {
        var expression = '';

        if (choice.Type == 'choice') {
            expression = choice.Question + '(' + choice.Expression + ')';
        }
        else {
            if (choice.Expression.indexOf(' OR ') > -1) {
                expression = choice.replace(/ OR /g, " OR " + choice.Question + "(").replace(/ OR /g, ") OR ");
            }
        }

        return expression;
    },

    getGeneratedStrataCount: function () {
        return _.reduce(this.expressions, function (count, expression) {
            return count + (_.isArray(expression.Expressions) ? expression.Expressions.length : 1);
        }, 0);
    },

    insertExpression: function (expression) {
        var index = this.expressions.map(function (item) { return item.Id; }).indexOf(expression.Id);
        if (index == -1) {
            //insert after the last choice of the same question                    
            var index = this.expressions.map(function (item) { return item.Question; }).lastIndexOf(expression.Question);
            if (index == -1)
                this.expressions.push(expression);
            else
                this.expressions.splice(index + 1, 0, expression);
        }
    },

    clearChoices: function () {
        this.selectedChoices = [];
        this.setLeftPanButtonsState();
        this.choicesListView.a4listview("refresh");
    },

    setLeftPanButtonsState: function () {
        this.groupButton.prop('disabled', true);
        this.crossButton.prop('disabled', true);
        this.addButton.prop('disabled', true);

        var questionsHavingChoicesSelected = 0;
        var isSingleChoiceSelected = false;
        var isGroupSelected = false;

        for (var index in this.selectedChoices) {
            var selectedGroups = this.selectedChoices[index].filter(function (item) { return item.Type == 'group' });
            if (selectedGroups.length > 0) {
                isGroupSelected = true;
            }

            if (this.selectedChoices[index].length > 0) {
                this.addButton.prop('disabled', false);
                questionsHavingChoicesSelected++;
            }

            if (this.selectedChoices[index].length == 1) {
                isSingleChoiceSelected = true;
            }
            else if (this.selectedChoices[index].length > 1) {
                this.groupButton.prop('disabled', false);
            }

            if (questionsHavingChoicesSelected > 1) {
                this.crossButton.prop('disabled', false);
            }
        }

        if (isGroupSelected || isSingleChoiceSelected) {
            this.groupButton.prop('disabled', true);
        }
    },

    getChoicesConcatForGroup: function (choices) {
        if (choices.length < 2)
            return;

        var firstChoice = choices[0];
        var lastChoice = choices[choices.length - 1];
        var isConsecutiveChoices = choices.length == lastChoice.Index - firstChoice.Index + 1;

        if (isConsecutiveChoices) {
            return {
                Code: firstChoice.Code + ' - ' + lastChoice.Code,
                Label: firstChoice.Label + '-' + lastChoice.Label,
                Name: firstChoice.Name + '-' + lastChoice.Name,
                Expression: firstChoice.Question + '(' + '[#' + firstChoice.Index + '-#' + lastChoice.Index + '])'
            };
        }
        else {
            return {
                Code: choices.map(function (choice) { return choice.Code }).join(', '),
                Label: choices.map(function (choice) { return choice.Label }).join(' OR '),
                Name: choices.map(function (choice) { return choice.Name }).join(' OR '),
                Expression: choices.map(function (choice) { return choice.Question + '(#' + choice.Index + ')' }).join(' OR ')
            };
        }
    }
}

var pageSummary = {
    context: $(".v-strataDefinitionWizard"),
    stratas: [],
    editedStrata: {},
    stratasDataTable: null,

    onShowPage: function () {
        if (this.stratasDataTable) {
            var updatedStrata = pageSummary.stratasDataTable.a4datatable("getUpdatedItems");

            _.each(updatedStrata, function (stratum) {
                var criterion = stratum["Criterion"];

                if (criterion)
                    pageSummary.editedStrata[criterion] = { Label: stratum["Label"], Quota: stratum["Quota"] };
            })

            this.stratas = [];
        }

        var expressions = [];

        for (var i in pageSelection.expressions) {
            var exp = pageSelection.expressions[i].Expression;
            if (pageSelection.expressions[i].Type == 'cross') {
                for (var j in pageSelection.expressions[i].Expressions) {
                    expressions.push(pageSelection.expressions[i].Expressions[j]);
                }
            }
            else {
                expressions.push(pageSelection.expressions[i].Expression);
            }
        }

        var action = a4.getProjectAction("GenerateMultipleStrataForExpressions", "Quotas");

        var data = { expressions: expressions };
        $(".h-summary", this.context).block();

        $.when(a4.callServerMethod(action, data)).then(function (data) {
            if (pageSummary.editedStrata && _.keys(pageSummary.editedStrata).length > 0) {
                for (var i in data) {
                    var criterion = data[i]["Criterion"];
                    var stratum = pageSummary.editedStrata[criterion];

                    if (stratum) {
                        data[i]["Label"] = stratum["Label"];
                        data[i]["Quota"] = stratum["Quota"];
                    }
                }
            }

            pageSummary.initializeStrataDatatable(data);
        });
    },

    initializeStrataDatatable: function (strata) {
        $(".h-summary", this.context).unblock();

        new Promise(function(resolve) {
            pageSummary.stratasDataTable = $(".h-summary", this.context).a4datatable({
                serverSide: false,
                displaySearchBox: false,
                displayColumnSelector: false,
                rememberRowSelection: true,
                allowRowSelection: true,
                lengthMenu: [
                    [10, 20, 50, 100, 500, 1000],
                    ['10', '20', '50', '100', '500', '1000']
                ],
                height: "full",
                columns: [
                    { "Data": "Id", "Visible": false, "Key": true },
                    { "Data": "Criterion", "Title": resources.Criterion },
                    { "Data": "Label", "Title": resources.Label, "Editable": true },
                    {
                        "Data": "Quota",
                        "Title": resources.Quota,
                        "Editable": { "MinValue": 0, "Decimals": 0 },
                        "Type": "numeric"
                    }
                ],
                data: strata,
                multiEdit: true,
                selectRow: function(event, data) {
                    pageSelection.onSelectExpression(data.data[0].Id, data.isChecked);
                },
                toolBarItems: [{ "Action": "remove", "Label": resources.Remove }],
                toolBarClick: function(event, data) {
                    switch (data.action) {
                    case "remove":
                        _.each(data.rows,
                            function(row) {
                                delete pageSummary.editedStrata[row.Criterion];
                            });

                        pageSummary.remove(data.rows);
                        break;
                    };
                },
                createCallback: resolve
            });
        }).then(function() {
            pageSummary.setNavigantionButtonsState();
        });
    },

    setNavigantionButtonsState: function () {
        strataWizard.saveButton.prop('disabled', pageSummary.stratasDataTable.a4datatable("getTotalRecords") == 0);
        strataWizard.setNavigantionButtonState(0, true);
        strataWizard.setNavigantionButtonState(1, true);
    },

    remove: function (rows) {
        var strat = pageSummary.stratasDataTable.a4datatable("getRowsData");
        for (var i in rows) {
            for (var index in strat) {
                if (strat[index].Id == rows[i].Id) {
                    pageSummary.stratasDataTable.a4datatable("deleteRow", index);
                    strat.splice(index, 1);
                    break;
                }
            }
        }
        pageSummary.stratasDataTable.a4datatable("refresh", true, true);
        pageSummary.setNavigantionButtonsState();
    },
}

$(document).ready(function () {
    if (strataWizard.context.length > 0) {
        strataWizard.initialize();
    }
});